function randAdjMat = generateRandomAdjacencyMatrix(obj)
%GENERATERANDOMADJACENCYMATRIX Build randomAdjacencyMatrix using Adam's
%algorithm

[A labels] = getSquareMatrix(obj);

threshhold = 5;
A = double(A>5);

numIters = 100;

for i = 1:numIters
    % Add weight to a random connection for each node, with probability
    % proportional to its existing weight
    
    
    for k = 1:size(A,1)
        options = [];
        idxs = find(A(k,:));
        
        for j = 1:numel(idxs)
            options = [options repmat(idxs(j),[1,A(k,idxs(j))])];
        end
        
        if numel(options)>0
            j = randsample(options,1);
            A(k,j) = A(k,j) + 1;
        end
        
    end
end

randAdjMat = AdjacencyMatrix(A,labels,labels','Random matrix');
h = loadDistribution(randAdjMat);

end

        